% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_constraints.R
\name{plot_constraint_fulfillment,list-method}
\alias{plot_constraint_fulfillment,list-method}
\title{Comparison of Evaluation Results.}
\usage{
\S4method{plot_constraint_fulfillment}{list}(
  primers,
  settings,
  active.constraints,
  plot.p.vals = FALSE,
  ncol = 2,
  highlight.set = NULL
)
}
\arguments{
\item{primers}{A list of \code{Primers} objects.}

\item{settings}{A \code{DesignSettings} object.}

\item{active.constraints}{The identifiers of constarints to be plotted for fulfillment.}

\item{plot.p.vals}{Whether p-values from Fisher's exact test
should be annotated for every primer set.}

\item{ncol}{The number of columns for facet wrap.}

\item{highlight.set}{Identifiers of primer sets to be highlighted.}
}
\value{
Plot indicating the ratio of primers
fulfilling the constraints specified in \code{constraint.settings}
for each primer set in \code{primers}.
}
\description{
Plots the percentage of primers fulfilling the specified
constraints for multiple primer sets.
}
\keyword{internal}
