% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primers.R
\name{cbind2,Primers,ANY-method}
\alias{cbind2,Primers,ANY-method}
\alias{rbind2,Primers,ANY-method}
\alias{[,Primers,ANY-method}
\alias{[,Primers-method}
\alias{$<-,Primers-method}
\title{S4 cbind for Primers.}
\usage{
\S4method{cbind2}{Primers,ANY}(x, y, ...)

\S4method{rbind2}{Primers,ANY}(x, y, ...)

\S4method{[}{Primers,ANY}(x, i, j, ..., drop = TRUE)

\S4method{$}{Primers}(x, name) <- value
}
\arguments{
\item{x}{The Primers data frame.}

\item{y}{Another data frame.}

\item{...}{Other arguments to the slice operator.}

\item{i}{The row index.}

\item{j}{The column index.}

\item{drop}{Simplify data frame?}

\item{name}{The name of the column.}

\item{value}{The values of the column.}
}
\value{
Cbinded primer data frame.

Rbinded primer data frame.

Subset of primer data frame.

Primer data frame with replaced column.
}
\description{
S4 cbind function for Primers.

S4 rbind function for Primers.

Slices a Primers data frame.

Stores data in a column of a Primers data frame.
}
\examples{
data(Ippolito)
primer.df <- cbind2(primer.df, seq_len(nrow(primer.df)))
data(Ippolito)
primer.df <- primer.df[1:2,]
data(Ippolito)
primer.df$Forward[1] <- "ctagcgggaccg"
}
\keyword{internal}
