% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owl_ops.R
\name{setup_entities}
\alias{setup_entities}
\title{construct owlents instance from an owl file}
\usage{
setup_entities(owlfn)
}
\arguments{
\item{owlfn}{character(1) path to valid owl ontology}
}
\value{
instance of owlents, which is a list with clnames (
a vector of term names in form `[namespace]_[tag]`), allents
(a list with python references to owlready2 entities, that
can be operated on using owlready2.EntityClass methods),
owlfn (filename), iri (IRI), call (record of call producing
the entity.)
}
\description{
construct owlents instance from an owl file
}
\examples{
pa = get_ordo_owl_path()
o2 = try(reticulate::import("owlready2"), silent=TRUE)
if (!inherits(o2, "try-error")) {
 orde = setup_entities(pa)
 orde
 ancestors(orde[1000:1001])
 labels(orde[1000:1001])
}
}
