% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapNaive.R
\name{selectFromMap}
\alias{selectFromMap}
\title{select a set of elements from a term 'map' and return a contribution to a data.frame}
\usage{
selectFromMap(namedvec, index)
}
\arguments{
\item{namedvec}{named character vector, as returned from \code{\link{mapOneNaive}}}

\item{index}{numeric() or integer(), typically of length one}
}
\value{
a data.frame; if \code{index} does not inherit from
\code{numeric}, a data.frame of one row with columns 'ontoid'
and 'term' populated with \code{NA_character_} is returned,
otherwise a similarly named data.frame is returned with
contents from the selected elements of \code{namedvec}
}
\description{
select a set of elements from a term 'map' and return a contribution to a data.frame
}
\examples{
#co = ontoProc::getCellOnto()
co = getOnto("cellOnto", year_added="2023")
mast = mapOneNaive("astrocyte", co)
selectFromMap(mast, 1)
}
