% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ontoDiff.R
\name{ontoDiff}
\alias{ontoDiff}
\title{Display Version Differences}
\usage{
ontoDiff(newonto, oldonto, terms2use, cex = 0.8, ...)
}
\arguments{
\item{newonto}{the newest version of the ontology}

\item{oldonto}{the old version of the ontology}

\item{terms2use}{terms of interest}

\item{cex}{numeric(1) defaults to .8, supplied to Rgraphviz::graph.par}

\item{...}{passed to onto_plot of ontologyPlot}
}
\value{
onto_plot2 style plot with version differences highlighted
}
\description{
Highlights in green the terms that are present in the new ontology but not the old one
}
\note{
Credit to ontoPlot for the use of some of its functions.
}
\examples{
cl = getOnto("diseaseOnto")
cl2 = getOnto(ontoname = "diseaseOnto", year_added = "2021")
cl3k = c("DOID:0040064","DOID:0040076","DOID:0081127","DOID:0081126","DOID:0081131","DOID:0060034")
ontoDiff(cl,cl2,cl3k)
}
