% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nio_details.R
\name{jowl2classgraph_nio}
\alias{jowl2classgraph_nio}
\title{extract class relationship graph from JSON representation of OWL for NIO}
\usage{
jowl2classgraph_nio(jsonpath, dropstrings = NULL)
}
\arguments{
\item{jsonpath}{character(1) path to JSON, typically generated by java robot applied to owl}

\item{dropstrings}{character(), strings to be excised from class names}
}
\value{
graphNEL with edgemode 'directed'
}
\description{
extract class relationship graph from JSON representation of OWL for NIO
}
\examples{
if (!requireNamespace("graph")) stop("install graph package from Bioconductor to use this function")
jpath = system.file("json", "nio.json.gz", package="ontoProc")
cg = jowl2classgraph_nio(jpath,
  dropstrings = "http://purl.org/autism-ontology/1.0/autism-rules.owl#")
head(graph::nodes(cg))
}
