% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_classes.R
\name{common_classes}
\alias{common_classes}
\title{list and count samples with common ontological annotation in two SEs}
\usage{
common_classes(ont, se1, se2)
}
\arguments{
\item{ont}{instance of ontologyIndex ontology}

\item{se1}{a SummarizedExperiment using `label.ont` in colData
to provide ontological tags (from `ont`) for samples}

\item{se2}{a SummarizedExperiment using `label.ont` in colData
to provide ontological tags (from `ont`) for samples}
}
\value{
a data.frame with rownames given by the
common tags, the class names as column `clname`, and
counts of samples bearing the given tags in remaining columns.
}
\description{
list and count samples with common ontological annotation in two SEs
}
\examples{
if (requireNamespace("celldex")) {
  imm = celldex::ImmGenData()
  if ("label.ont" \%in\% names(SummarizedExperiment::colData(imm))) {
    cl = getOnto("cellOnto")
    blu = celldex::BlueprintEncodeData()
    common_classes( cl, imm, blu )
    }
  }
}
