#' oncoscanR: an R package to perform secondary analysis of Copy Number 
#' Variation data. 
#' 
#' Allows computation of different homologous recombination deficiency (HRD) 
#' scores to identify PARP inhibitors responders. The package also allows for 
#' computation of the tandem duplication plus score (TDplus; hallmark of 
#' CDK12-mutated tumors) and the identification of arm-level alterations (e.g. 
#' gain of chromosome arm 1p).
#' 
#' The package is tailored for the ThermoFisher Oncoscan assay analyzed with 
#' their Chromosome Alteration Suite (ChAS) but can be adapted to any input.
#' 
#' To learn more about \code{oncoscanR}, see the vignette using 
#' \code{browseVignettes(package = "oncoscanR")}.
#' 
#' @keywords internal
"_PACKAGE"

## usethis namespace: start
## usethis namespace: end
NULL
