% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition_agreement.R
\name{partitionAgreement}
\alias{partitionAgreement}
\title{Partition Agreement calculation between two clustering runs}
\usage{
partitionAgreement(
  data,
  algorithm.1 = "hierarchical",
  measure.1 = "canberra",
  hier.agglo.algorithm.1 = "average",
  algorithm.2 = "hierarchical",
  measure.2 = "manhattan",
  hier.agglo.algorithm.2 = "average",
  number.of.clusters = 5
)
}
\arguments{
\item{data}{A dataframe, where columns are features and rows are data points}

\item{algorithm.1}{Second algorithm to be used (spectral/kmeans/hierarchical)}

\item{measure.1}{Concerns the first algorithm to be used and represents a
kernel for Spectral/kmeans or a distance measure for hierarchical clustering}

\item{hier.agglo.algorithm.1}{Concerns the first algorithm to be used and
represents the agglomerative method for hierarchical clustering (not used in
spectral/kmeans clustering)}

\item{algorithm.2}{First algorithm to be used (spectral/kmeans/hierarchical)}

\item{measure.2}{Concerns the second algorithm to be used and represents a
kernel for Spectral/kmeans or a distance measure for hierarchical clustering}

\item{hier.agglo.algorithm.2}{Concerns the second algorithm to be used and
represents the agglomerative method for hierarchical clustering (not used in
spectral/kmeans clustering)}

\item{number.of.clusters}{The upper limit of clusters to form starting from 2}
}
\value{
An object of class "partitionAgreement" containing agreements
(Rand Indexes) from 1 cluster (ARI=0) up to the number of clusters requested
}
\description{
Calculate the agreement (0,1) between two partitioning generated by two
clustering runs using the adjust Rand Index. We can use three clustering
algorithms (spectral, kmeans and hierarchical) along with the following
parameters for each:
}
\details{
Spectral
 kernels: rbfdot, polydot, vanilladot, tanhdot, laplacedot, besseldot,
 anovadot, splinedot

 K-means
 kernels: "Hartigan-Wong", Lloyd, Forgy, MacQueen

Hierarchical
 Agglomeration methods: average, ward.D, ward.D2, single, complete, mcquitty,
 median, centroid

 Distance measures: euclidean, manhattan, canberra, minkowski, maximum
}
\examples{
partitionAgreement(toy_genes, algorithm.1 = "hierarchical",
measure.1 = "canberra",hier.agglo.algorithm.1 = "average",
algorithm.2 = "hierarchical",measure.2 = "manhattan",
hier.agglo.algorithm.2 = "average",number.of.clusters = 3)

partitionAgreement(toy_genes, algorithm.1 = "spectral", measure.1 = "rbfdot",
algorithm.2 = "kmeans",measure.2 = "Lloyd", number.of.clusters = 5)
}
