% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods-Matched.R
\name{indices}
\alias{indices}
\alias{indices,Matched-method}
\title{Get indices of matched set}
\usage{
indices(x, set = "matched", ...)

\S4method{indices}{Matched}(x, set)
}
\arguments{
\item{x}{Matched object.}

\item{set}{A character string describing from which set to extract indices.
can be one of 'focal', 'matched', 'pool', or 'unmatched'.}

\item{...}{Additional arguments.}
}
\value{
An integer vector corresponding
to the indices in the \code{focal} or \code{pool} which comprise the
"focal" or c("matched", "pool", "unmatched") sets.
}
\description{
Extracts the indices of a specified matched set
from a Matched object.
}
\details{
Indices from 'focal' come from the \code{focal} set
of \code{matchRanges()} used to construct the \code{Matched}
object while indices from 'matched', 'pool', and 'unmatched'
come from the \code{pool} set. Default returns the 'matched' indices
from the \code{pool} set.
}
\examples{
set.seed(123)
mdf <- makeExampleMatchedDataSet(matched = TRUE)
head(indices(mdf))

head(indices(mdf, set = 'focal'))
head(indices(mdf, set = 'pool'))
head(indices(mdf, set = 'matched'))
head(indices(mdf, set = 'unmatched'))

}
