% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_clustering.R
\name{cluster_features}
\alias{cluster_features}
\title{Cluster correlated features originating from the same metabolite}
\usage{
cluster_features(
  object,
  mz_col = NULL,
  rt_col = NULL,
  all_features = FALSE,
  rt_window = 1/60,
  corr_thresh = 0.9,
  d_thresh = 0.8,
  assay.type = NULL
)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{mz_col}{the column name in feature data that holds mass-to-charge 
ratios}

\item{rt_col}{the column name in feature data that holds retention times}

\item{all_features}{logical, should all features be included in the 
clustering? If FALSE, as the default, flagged features are not included in 
clustering}

\item{rt_window}{the retention time window for potential links
NOTE: use the same unit as the retention time}

\item{corr_thresh}{the correlation threshold required for potential links 
between features}

\item{d_thresh}{the threshold for the relative degree required by each node}

\item{assay.type}{character, assay to be used in case of multiple assays}
}
\value{
a SummarizedExperiment object, with median peak area 
(MPA), the cluster ID, the features in the cluster, and cluster size added 
to feature data.
}
\description{
Clusters features potentially originating from the same compound. Features 
with high Pearson correlation coefficient and small retention time 
difference are linked together. Then clusters are formed by setting a 
threshold for the relative degree that each node in a cluster needs
to fulfil. Each cluster is named after the feature with the highest median 
peak area (median abundance). This is a wrapper around numerous functions 
that are based on the MATLAB code by David Broadhurst.
}
\examples{
data(toy_notame_set)
# The parameters are really weird because example data is imaginary
clustered <- cluster_features(toy_notame_set, rt_window = 1,
  corr_thresh = 0.5, d_thresh = 0.6)

}
