% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_utils.R
\name{save_plot}
\alias{save_plot}
\title{Save plot to chosen format}
\usage{
save_plot(p, file, ...)
}
\arguments{
\item{p}{a ggplot object}

\item{file}{the file path}

\item{...}{other arguments to plot function, like width and height}
}
\value{
None, the function is invoked for its plot-saving side effect.
}
\description{
Saves the given plot to a file. Supports pdf, svg, emf, png and tiff formats.
If an error occurs with the plot, an empty file is created.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}
data(toy_notame_set, package = "notame")

p <- plot_sample_heatmap(toy_notame_set, group = "Group")

save_plot(p, file = "test.pdf")
\dontshow{setwd(.old_wd)}

}
\seealso{
\code{\link[grDevices]{pdf}},
\code{\link[devEMF]{emf}},
\code{\link[grDevices]{svg}},
\code{\link[grDevices]{png}},
\code{\link[grDevices]{tiff}}
}
