% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{perform_auc}
\alias{perform_auc}
\title{Area under curve}
\usage{
perform_auc(object, time, subject, group, assay.type = NULL)
}
\arguments{
\item{object}{a \code{
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object}

\item{time, subject, group}{column names of pheno data holding time, 
subject and group labels}

\item{assay.type}{character, assay to be used in case of multiple assays}
}
\value{
A pseudo SummarizedExperiment object with the AUCs.
}
\description{
Compute area under curve (AUC) for each subject and feature.
Creates a pseudo SummarizedExperiment object, where the 
"samples" are subjects (or subject/group combinations in case the same 
subjects are submitted to different treatments) and the "abundances" are 
AUCs. This object can then be  used to compute results of e.g. t-tests of 
AUCs between groups.
}
\examples{
data(toy_notame_set, package = "notame")
# Drop QC samples before computing AUCs
aucs <- perform_auc(notame::drop_qcs(toy_notame_set), time = "Time", 
                    subject = "Subject_ID", group = "Group")
# t-test with the AUCs
t_test_results <- perform_t_test(aucs, formula_char = "Feature ~ Group")

}
\seealso{
\code{\link[PK]{auc}}
}
