% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmb_accessors.R
\name{nmb_get_bs_weights}
\alias{nmb_get_bs_weights}
\title{Accessor function for block score weights}
\usage{
nmb_get_bs_weights(nmb_object)
}
\arguments{
\item{nmb_object}{A `NipalsResult` object.}
}
\value{
a matrix containing the block score weights.
}
\description{
Retrieves the block score weights
from a `NipalsResult` object, typically output from `nipals_multiblock()`.
}
\examples{
data("NCI60")
data_blocks_mae <- simple_mae(data_blocks,row_format="sample",
                             colData=metadata_NCI60)
mcia_out <- nipals_multiblock(data_blocks_mae, num_PCs = 10)
block_score_weights <- nmb_get_bs_weights(mcia_out)
}
