% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata_colors.R
\name{get_metadata_colors}
\alias{get_metadata_colors}
\title{Assigning colors to different values of a metadata column}
\usage{
get_metadata_colors(
  mcia_results,
  color_col,
  color_pal = scales::viridis_pal,
  color_pal_params = list()
)
}
\arguments{
\item{mcia_results}{object returned from nipals_multiblock() function}

\item{color_col}{an integer or string specifying the column that will be
used for color_col}

\item{color_pal}{a function which returns color palettes (e.g. scales)}

\item{color_pal_params}{list of parameters for the corresponding function}
}
\value{
List of metadata columns with assigned colors
}
\description{
Creates a list of metadata columns and associated colors
for plotting. The default palette was chosen to be color-blindness friendly.
}
\examples{
data(NCI60)
data_blocks_mae <- simple_mae(data_blocks,row_format="sample",
                               colData=metadata_NCI60)
mcia_results <- nipals_multiblock(data_blocks_mae, num_PCs = 10,
                                  plots = "none", tol = 1e-12)
colors_omics <- get_metadata_colors(mcia_results, "cancerType",
                                    color_pal_params = list(option = "E"))
}
