% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deflate_block_gs.R
\name{deflate_block_gs}
\alias{deflate_block_gs}
\title{Deflation via global scores}
\usage{
deflate_block_gs(df, gs)
}
\arguments{
\item{df}{a data frame in "sample" x "variable" format}

\item{gs}{a global scores vector in sample space}
}
\value{
the deflated data frame
}
\description{
Removes data from a data frame in the direction of a given
global scores vector.
}
\details{
Subtracts the component of each column in the direction of a given
global scores vector to yield a `deflated' data matrix.
}
\examples{
df <- matrix(rbinom(15, 1, prob = 0.3), ncol = 3)
global_score <- rbinom(5, 1, prob = 0.3)
deflated_data <- deflate_block_gs(df, global_score)

}
