% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importSJ.R
\name{importSJ}
\alias{importSJ}
\title{Import STAR Splice Junctions}
\usage{
importSJ(x, stripPaths = TRUE)
}
\arguments{
\item{x}{vector of file paths to SJ.out.tab files}

\item{stripPaths}{logical(1) Remove directory prefixes from the file paths
in x}
}
\value{
A \code{tibble}
}
\description{
Import the SJ.out.tab files produced by STAR
}
\details{
Imports one or more splice-junction output files as produced by STAR.
If all are located in separated directories with identical names, be sure
to set the argument stripPaths = FALSE

All co-ordinates are 1-based, in keeping with the STAR manual
}
\examples{
sjFiles <- system.file("extdata", "SJ.out.tab", package = "ngsReports")
# Import leaving the complete file path in the column Filename
# The argument srtipPaths is set as TRUE by default
df <- importSJ(sjFiles, stripPaths = FALSE)

}
