% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netprioR-class.R
\docType{class}
\name{netprioR-class}
\alias{netprioR}
\alias{netprioR,list,matrix,factor-method}
\alias{netprioR-class}
\title{netprioR}
\usage{
netprioR(networks, phenotypes, labels, ...)

\S4method{netprioR}{list,matrix,factor}(networks, phenotypes, labels,
  fit.model = FALSE, a = 0.1, b = 0.1, sigma2 = 0.1, tau2 = 100,
  eps = 1e-10, max.iter = 500, thresh = 1e-06, use.cg = FALSE,
  thresh.cg = 1e-06, nrestarts = 5, max.cores = detectCores(),
  verbose = TRUE, ...)
}
\arguments{
\item{networks}{List of NxN adjacency matrices of gene-gene similarities}

\item{phenotypes}{Matrix of dimension NxP containing covariates}

\item{labels}{Vector of Nx1 labels for all genes (NA if no label available)}

\item{...}{Additional arguments}

\item{fit.model}{Indicator whether to fit the model}

\item{a}{Shape parameter of Gamma prior for W}

\item{b}{Scale parameter of Gamma prior for W}

\item{sigma2}{Cariance for Gaussian labels}

\item{tau2}{Variance for Gaussian prior for beta}

\item{eps}{Small value added to diagonal of Q in order to make it non-singular}

\item{max.iter}{Maximum number of iterations for EM}

\item{thresh}{Threshold for termination of EM with respect to change in parameters}

\item{use.cg}{Flag whether to use conjugate gradient instead of exact computation of expectations}

\item{thresh.cg}{Threshold for the termination of the conjugate gradient solver}

\item{nrestarts}{Number of restarts for EM}

\item{max.cores}{Maximum number of cores to use for parallel computation}

\item{verbose}{Print verbose output}
}
\value{
A \code{\linkS4class{netprioR}} object
}
\description{
Class that represents a netprioR model.
}
\section{Slots}{

\describe{
\item{\code{networks}}{List of NxN adjacency matrices of gene-gene similarities}

\item{\code{phenotypes}}{Matrix of dimension NxP containing covariates}

\item{\code{labels}}{Vector of Nx1 labels for all genes. NA if no label available.}

\item{\code{is.fitted}}{Flag indicating if model is fitted}

\item{\code{model}}{List containing estimated parameters and imputed missing data}
}}
\examples{
\donttest{ # runs long-ish
data(simulation)
np <- netprioR(networks = simulation$networks,
               phenotypes = simulation$phenotypes,
               labels = simulation$labels.obs,
               fit.model = TRUE)
summary(np)          
}
}
\author{
Fabian Schmich
}

