% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netplot.R
\name{plot_2networks}
\alias{plot_2networks}
\title{Plot two networks (GGMs)}
\usage{
plot_2networks(invcov1, invcov2, node.label = paste("X", 1:nrow(invcov1),
  sep = ""), main = c("", ""), ...)
}
\arguments{
\item{invcov1}{Inverse covariance matrix of GGM1.}

\item{invcov2}{Inverse covariance matrix of GGM2.}

\item{node.label}{Names of nodes.}

\item{main}{Vector (two elements) with network names.}

\item{...}{Other arguments (see plot.network).}
}
\value{
Figure with two panels (for each network).
}
\description{
Plot two networks (GGMs)
}
\examples{
n <- 70
p <- 30

## Specifiy sparse inverse covariance matrices,
## with number of edges in common equal to ~ 0.8*p
gen.net <- generate_2networks(p,graph='random',n.nz=rep(p,2),
                              n.nz.common=ceiling(p*0.8))

invcov1 <- gen.net[[1]]
invcov2 <- gen.net[[2]]

plot_2networks(invcov1,invcov2,label.pos=0,label.cex=0.7)
}
\author{
nicolas
}
