% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet.R
\name{logratio}
\alias{logratio}
\title{Log-likelihood-ratio statistics used in DiffNet}
\usage{
logratio(x1, x2, x, sig1, sig2, sig, mu1, mu2, mu)
}
\arguments{
\item{x1}{data-matrix sample 1}

\item{x2}{data-matrix sample 2}

\item{x}{pooled data-matrix}

\item{sig1}{covariance sample 1}

\item{sig2}{covariance sample 2}

\item{sig}{pooled covariance}

\item{mu1}{mean sample 1}

\item{mu2}{mean sample 2}

\item{mu}{pooled mean}
}
\value{
Returns a list with named elements 'twiceLR', 'sig1', 'sig2', 'sig'.
        'twiceLR' is twice the log-likelihood-ratio statistic.
}
\description{
Log-likelihood-ratio statistics used in Differential Network
}
\examples{
x1=matrix(rnorm(100),50,2)
x2=matrix(rnorm(100),50,2)
logratio(x1,x2,rbind(x1,x2),diag(1,2),diag(1,2),diag(1,2),c(0,0),c(0,0),c(0,0))$twiceLR
}
\author{
n.stadler
}
