% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixglasso.R
\name{bwprun_mixglasso}
\alias{bwprun_mixglasso}
\title{bwprun_mixglasso}
\usage{
bwprun_mixglasso(x, n.comp.min = 1, n.comp.max, lambda = sqrt(2 *
  nrow(x) * log(ncol(x)))/2, pen = "glasso.parcor",
  selection.crit = "mmdl", term = 10^{     -3 }, min.compsize = 5,
  init = "kmeans.hc", my.cl = NULL, modelname.hc = "VVV",
  nstart.kmeans = 1, iter.max.kmeans = 10, reinit.out = FALSE,
  reinit.in = FALSE, mer = TRUE, del = TRUE, ...)
}
\arguments{
\item{x}{Input data matrix}

\item{n.comp.min}{Minimum number of components. Take n.comp.min=1 !}

\item{n.comp.max}{Maximum number of components}

\item{lambda}{Regularization parameter. Default=sqrt(2*n*log(p))/2}

\item{pen}{Determines form of penalty: glasso.parcor (default), glasso.invcov, glasso.invcor}

\item{selection.crit}{Selection criterion. Default='mmdl'}

\item{term}{Termination criterion of EM algorithm. Default=10^-3}

\item{min.compsize}{Stop EM if any(compsize)<min.compsize; Default=5}

\item{init}{Initialization. Method used for initialization
init={'cl.init','r.means','random','kmeans','kmeans.hc','hc'}. Default='kmeans.hc'}

\item{my.cl}{Initial cluster assignments; need to be provided if init='cl.init' (otherwise this param is ignored). Default=NULL}

\item{modelname.hc}{Model class used in hc. Default="VVV"}

\item{nstart.kmeans}{Number of random starts in kmeans; default=1}

\item{iter.max.kmeans}{Maximal number of iteration in kmeans; default=10}

\item{reinit.out}{Re-initialization if compsize<min.compsize (at the start of algorithm) ?}

\item{reinit.in}{Re-initialization if compsize<min.compsize (at the bwprun-loop level of algorithm) ?}

\item{mer}{Merge closest comps for initialization}

\item{del}{Delete smallest comp for initialization}

\item{...}{Other arguments. See mixglasso_init}
}
\value{
list consisting of
\item{selcrit}{Selcrit for all models with number of components between n.comp.min and n.comp.max}
\item{res.init}{Initialization for all components}
\item{comp.name}{List of names of components. Indicates which states where merged/deleted during backward pruning}
\item{re.init.in}{Logical vector indicating whether re-initialization was performed or not}
\item{fit.mixgl.selcrit}{Results for model with optimal number of components. List see mixglasso_init}
}
\description{
Mixglasso with backward pruning
}
\details{
This function runs mixglasso with various number of mixture components:
It starts with a too large number of components and iterates towards solutions
with smaller number of components by initializing using previous solutions.
}
\examples{
##generate data
set.seed(1)
n <- 1000
n.comp <- 3
p <- 10

# Create different mean vectors
Mu <- matrix(0,p,n.comp)

nonzero.mean <- split(sample(1:p),rep(1:n.comp,length=p))
for(k in 1:n.comp){
  Mu[nonzero.mean[[k]],k] <- -2/sqrt(ceiling(p/n.comp))
}

sim <- sim_mix_networks(n, p, n.comp, Mu=Mu)

##run mixglasso

fit <-  bwprun_mixglasso(sim$data,n.comp=1,n.comp.max=5,selection.crit='bic')
plot(fit$selcrit,ylab='bic',xlab='Num.Comps',type='b')
}
\author{
n.stadler
}
