% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netboost.R
\name{nb_transfer}
\alias{nb_transfer}
\title{Transfer of Netboost clustering to new data.}
\usage{
nb_transfer(
  nb_summary = NULL,
  new_data = NULL,
  scale = FALSE,
  robust_PCs = FALSE,
  only_module_membership = FALSE
)
}
\arguments{
\item{nb_summary}{Netboost results as generated by the nb_summary 
function.}

\item{new_data}{Data frame were rows correspond to samples and columns to
features.}

\item{scale}{Logical. Should data be scaled and centered?}

\item{robust_PCs}{Should PCA be calculated on ranked data (Spearman PCA)?
Rotations will not correspond to original data if this is applied.}

\item{only_module_membership}{Logical. Should only module memberships be
transfered and PCs be newly computed?}
}
\value{
List
}
\description{
Transfer of Netboost clustering to new data.
}
\examples{
data('tcga_aml_meth_rna_chr18',  package='netboost')
results <- netboost(datan = tcga_aml_meth_rna_chr18, stepno = 20L,
    soft_power = 3L, min_cluster_size = 10L, n_pc = 2, scale=TRUE,
    ME_diss_thres = 0.25, qc_plot=FALSE)
ME_transfer <- nb_transfer(nb_summary = results,
    new_data = tcga_aml_meth_rna_chr18,
    scale = TRUE)
all(round(results[["MEs"]], 12) == round(ME_transfer, 12))

}
