% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netboost.R
\name{nb_dist}
\alias{nb_dist}
\title{Calculate distance (external wrapper for internal C++ function)
Parallelisation inside C++ program with RcppParallel.}
\usage{
nb_dist(
  filter,
  datan,
  soft_power = 2,
  cores = getOption("mc.cores", 2L),
  verbose = getOption("verbose"),
  method = c("pearson", "kendall", "spearman")
)
}
\arguments{
\item{filter}{Filter-Matrix as generated by the nb_filter function.}

\item{datan}{Data frame were rows correspond to samples and columns to
features.}

\item{soft_power}{Integer. Exponent of the transformation. Set 
automatically based on the scale free topology criterion if unspecified.}

\item{cores}{Integer. Amount of CPU cores used (<=1 : sequential).}

\item{verbose}{Additional diagnostic messages.}

\item{method}{A character string specifying the method to be used for
correlation coefficients.}
}
\value{
Vector with distances.
}
\description{
Calculate distance (external wrapper for internal C++ function)
Parallelisation inside C++ program with RcppParallel.
}
\examples{
 data('tcga_aml_meth_rna_chr18', package='netboost')
 cores <- as.integer(getOption('mc.cores', 2))
 datan <- as.data.frame(scale(tcga_aml_meth_rna_chr18, center=TRUE,
 scale=TRUE))
 filter <- nb_filter(datan=datan, stepno=20L, until=0L, progress=1000L,
 cores=cores,mode=2L)
 dist <- nb_dist(datan=datan, filter=filter, soft_power=3L, cores=cores)
 summary(dist)

}
