% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_networks_simple_operations.r
\name{ndex_create_network}
\alias{ndex_create_network}
\title{Create a Network at a server from RCX data}
\usage{
ndex_create_network(ndexcon, rcx)
}
\arguments{
\item{ndexcon}{object of class NDExConnection link{ndex_connect}}

\item{rcx}{\code{\link[RCX]{RCX-object}} object}
}
\value{
UUID of the newly created network
}
\description{
This method creates a new network on the NDEx server from the given RCX object
}
\details{
\strong{Note: In future `ndexr` uses the \link[RCX]{RCX-object} from the corresponding package to handle the networks!}
}
\note{
Requires an authorized user! (ndex_connect with credentials)

Compatible to NDEx server version 1.3 and 2.0
}
\section{REST query}{

POST (multipart/form-data): ndex_config$api$network$create$url
data: CXNetworkStream = data
}

\examples{
## Establish a server connection with credentials 
# ndexcon = ndex_connect('MyAccountName', 'MyPassword')
## Find a network and get its UUID
# networks = ndex_find_networks(ndexcon,"p53", "nci-pid")
# networkId = networks[1,"externalId"]
## Get the network data 
# rcx = ndex_get_network(ndexcon, networkId) 
## Do some changes to rcx..
## and create a new network
# networkId = ndex_create_network(ndexcon, rcx)
NULL
}
