% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfFlowSet-accessors.R
\name{getIndices,ncdfFlowSet,character-method}
\alias{getIndices,ncdfFlowSet,character-method}
\alias{getIndices}
\alias{initIndices,ncdfFlowSet-method}
\alias{initIndices}
\alias{updateIndices,ncdfFlowSet,character,logical-method}
\alias{updateIndices}
\title{\code{getIndices} extracts the event indices of one or multiple samples from ncdfFlowSet}
\usage{
\S4method{getIndices}{ncdfFlowSet,character}(obj, y)

\S4method{initIndices}{ncdfFlowSet}(obj)

\S4method{updateIndices}{ncdfFlowSet,character,logical}(obj, y, z)
}
\arguments{
\item{obj}{\code{ncdfFlowSet} object}

\item{y}{\code{character} sample name}

\item{z}{\code{logical} vector to be assigned.}
}
\value{
a logical vector.
}
\description{
These functions are mainly for internal usage and normally not to be used by users.
}
\examples{
data(GvHD)
nc <- ncdfFlowSet(GvHD[1:2])
sn <- sampleNames(nc)[1]
nrow(nc[[sn]])
getIndices(nc, sn) #initial index is NA 
#subset with filter
library(flowStats)
morphGate <- norm2Filter("FSC-H", "SSC-H", filterId = "MorphologyGate",scale = 2)
nc1 <- Subset(nc, morphGate)
ind <- getIndices(nc1, sn)
# all.equal(sum(ind), nrow(nc1[[sn]]))
initIndices(nc1)
getIndices(nc1, sn) #reset indices
}
