% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allMethods.R
\docType{methods}
\name{alignData,ncGTWoutput-method}
\alias{alignData,ncGTWoutput-method}
\alias{alignData}
\title{ncGTWoutput-accessors}
\usage{
\S4method{alignData}{ncGTWoutput}(object)
}
\arguments{
\item{object}{a \code{\link{ncGTWoutput}} object.}
}
\value{
\code{alignData} returns a matrix in which each row is a sample
profile after downsampling.
}
\description{
Accessors to the alignment information and result by ncGTW.
}
\examples{
# obtain data
data('xcmsExamples')
xcmsLargeWin <- xcmsExamples$xcmsLargeWin
xcmsSmallWin <- xcmsExamples$xcmsSmallWin
ppm <- xcmsExamples$ppm

# detect misaligned features
excluGroups <- misalignDetect(xcmsLargeWin, xcmsSmallWin, ppm)

# obtain the paths of the sample files
filepath <- system.file("extdata", package = "ncGTW")
file <- list.files(filepath, pattern="mzxml", full.names=TRUE)

tempInd <- matrix(0, length(file), 1)
for (n in seq_along(file)){
    tempCha <- file[n]
    tempLen <- nchar(tempCha)
    tempInd[n] <- as.numeric(substr(tempCha, regexpr("example", tempCha) + 7,
        tempLen - 6))
}
# sort the paths by data acquisition order
file <- file[sort.int(tempInd, index.return = TRUE)$ix]
\dontrun{
# load the sample profiles
ncGTWinputs <- loadProfile(file, excluGroups)

# initialize the parameters of ncGTW alignment with default
ncGTWparam <- initncGTWparam()

# run ncGTW alignment
ncGTWoutputs <- vector('list', length(ncGTWinputs))
for (n in seq_along(ncGTWinputs))
    ncGTWoutputs[[n]] <- ncGTWalign(ncGTWinputs[[n]], xcmsLargeWin, 5,
        ncGTWparam = ncGTWparam)

data <- alignData(ncGTWoutputs[[1]])
rt <- scanRange(ncGTWoutputs[[1]])
paths <- ncGTWpath(ncGTWoutputs[[1]])
downSam <- downSample(ncGTWoutputs[[1]])
}
}
