% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncGTWwarp.R
\name{adjustRT}
\alias{adjustRT}
\title{Adjust retention time}
\usage{
adjustRT(xcmsLargeWin, ncGTWinput, ncGTWoutput, ppm)
}
\arguments{
\item{xcmsLargeWin}{A \code{\link[xcms]{xcmsSet-class}} object.}

\item{ncGTWinput}{A \code{\link{ncGTWinput}} object.}

\item{ncGTWoutput}{A \code{\link{ncGTWoutput}} object.}

\item{ppm}{Should be set as same as the one when performing the peak
detection function in \code{xcms}.}
}
\value{
A \code{\link{ncGTWwarp}} object.
}
\description{
This function produces the new warping functions (RT lists) with the
realignment result.
}
\details{
This function produces the new warping functions (RT lists) with the
realignment result.
}
\examples{
# obtain data
data('xcmsExamples')
xcmsLargeWin <- xcmsExamples$xcmsLargeWin
xcmsSmallWin <- xcmsExamples$xcmsSmallWin
ppm <- xcmsExamples$ppm

# detect misaligned features
excluGroups <- misalignDetect(xcmsLargeWin, xcmsSmallWin, ppm)

# obtain the paths of the sample files
filepath <- system.file("extdata", package = "ncGTW")
file <- list.files(filepath, pattern="mzxml", full.names=TRUE)

tempInd <- matrix(0, length(file), 1)
for (n in seq_along(file)){
    tempCha <- file[n]
    tempLen <- nchar(tempCha)
    tempInd[n] <- as.numeric(substr(tempCha, regexpr("example", tempCha) + 7,
        tempLen - 6))
}
# sort the paths by data acquisition order
file <- file[sort.int(tempInd, index.return = TRUE)$ix]
\dontrun{
# load the sample profiles
ncGTWinputs <- loadProfile(file, excluGroups)

# initialize the parameters of ncGTW alignment with default
ncGTWparam <- new("ncGTWparam")

# run ncGTW alignment
ncGTWoutputs <- vector('list', length(ncGTWinputs))
for (n in seq_along(ncGTWinputs))
    ncGTWoutputs[[n]] <- ncGTWalign(ncGTWinputs[[n]], xcmsLargeWin, 5,
        ncGTWparam = ncGTWparam)

# adjust RT with the realignment results from ncGTW
ncGTWres <- xcmsLargeWin
ncGTWRt <- vector('list', length(ncGTWinputs))
for (n in seq_along(ncGTWinputs)){
    adjustRes <- adjustRT(ncGTWres, ncGTWinputs[[n]], ncGTWoutputs[[n]], ppm)
    xcms::peaks(ncGTWres) <- ncGTWpeaks(adjustRes)
    ncGTWRt[[n]] <- rtncGTW(adjustRes)
}

# apply the adjusted RT to a xcmsSet object
xcms::groups(ncGTWres) <- excluGroups[ , 2:9]
xcms::groupidx(ncGTWres) <- xcms::groupidx(xcmsLargeWin)[excluGroups[ , 1]]
rtCor <- vector('list', length(xcms::filepaths(ncGTWres)))
for (n in seq_along(file)){
    rtCor[[n]] <- vector('list', dim(excluGroups)[1])
    for (m in seq_len(dim(excluGroups)[1]))
        rtCor[[n]][[m]] <- ncGTWRt[[m]][[n]]
}
slot(ncGTWres, 'rt')$corrected <- rtCor
}
}
