% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovery_prediction.R
\name{auto_predict_grid}
\alias{auto_predict_grid}
\title{Automatic filtering of signatures for exposure prediction gridded across
specific annotation}
\usage{
auto_predict_grid(
  musica,
  modality,
  signature_res,
  algorithm,
  model_id = NULL,
  result_name = "result",
  sample_annotation = NULL,
  min_exists = 0.05,
  proportion_samples = 0.25,
  rare_exposure = 0.4,
  verbose = TRUE,
  combine_res = TRUE,
  make_copy = FALSE,
  table_name = NULL
)
}
\arguments{
\item{musica}{Input samples to predict signature weights}

\item{modality}{Modality used for posterior prediction (e.g. SBS96)}

\item{signature_res}{Signatures to automatically subset from for prediction}

\item{algorithm}{Algorithm to use for prediction. Choose from
"lda_posterior", and decompTumor2Sig}

\item{model_id}{Name of model}

\item{result_name}{Name for result_list entry to save the results to. Default
\code{"result"}.}

\item{sample_annotation}{Annotation to grid across, if none given,
prediction subsetting on all samples together}

\item{min_exists}{Threshold to consider a signature active in a sample}

\item{proportion_samples}{Threshold of samples to consider a signature
active in the cohort}

\item{rare_exposure}{A sample will be considered active in the cohort if at
least one sample has more than this threshold proportion}

\item{verbose}{Print current annotation value being predicted on}

\item{combine_res}{Automatically combines a list of annotation results
into a single result object with zero exposure values for signatures not
found in a given annotation's set of samples}

\item{make_copy}{If \code{FALSE}, the inputted \code{\linkS4class{musica}}
object is updated and nothing is returned. If \code{TRUE}, a new
\code{\linkS4class{musica}} object is created and returned. Default
\code{FALSE}.}

\item{table_name}{Use modality instead}
}
\value{
Returns nothing or a new \code{\linkS4class{musica}} object,
depending on the \code{make_copy} parameter.
}
\description{
Automatic filtering of signatures for exposure prediction gridded across
specific annotation
}
\examples{
data(musica_annot)
data(cosmic_v2_sigs)
auto_predict_grid(
  musica = musica_annot, modality = "SBS96",
  signature_res = cosmic_v2_sigs, algorithm = "lda",
  sample_annotation = "Tumor_Subtypes"
)
auto_predict_grid(musica_annot, "SBS96", cosmic_v2_sigs, "lda")
}
