% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{extract_variants_from_matrix}
\alias{extract_variants_from_matrix}
\title{Extract variants from matrix or data.frame like objects}
\usage{
extract_variants_from_matrix(
  mat,
  chromosome_col = "Chromosome",
  start_col = "Start_Position",
  end_col = "End_Position",
  ref_col = "Tumor_Seq_Allele1",
  alt_col = "Tumor_Seq_Allele2",
  sample_col = "Tumor_Sample_Barcode",
  extra_fields = NULL
)
}
\arguments{
\item{mat}{An object that inherits from classes "matrix" or "data.frame"
Examples include a matrix, data.frame, or data.table.}

\item{chromosome_col}{The name of the column that contains the chromosome
reference for each variant. Default \code{"Chromosome"}.}

\item{start_col}{The name of the column that contains the start
position for each variant. Default \code{"Start_Position"}.}

\item{end_col}{The name of the column that contains the end
position for each variant. Default \code{"End_Position"}.}

\item{ref_col}{The name of the column that contains the reference
base(s) for each variant. Default \code{"Tumor_Seq_Allele1"}.}

\item{alt_col}{The name of the column that contains the alternative
base(s) for each variant. Default \code{"Tumor_Seq_Allele2"}.}

\item{sample_col}{The name of the column that contains the sample
id for each variant. Default \code{"Tumor_Sample_Barcode"}.}

\item{extra_fields}{Optionally extract additional columns from the
object. Default \code{NULL}.}
}
\value{
Returns a data.table of variants from a maf which can be used to
create a \code{musica} object.
}
\description{
Add Description
}
\examples{
maf_file <- system.file("extdata", "public_TCGA.LUSC.maf",
  package = "musicatk"
)
library(maftools)
maf <- read.maf(maf_file)
variants <- extract_variants_from_maf(maf = maf)
variants <- extract_variants_from_matrix(
  mat = variants,
  chromosome_col = "chr", start_col = "start", end_col = "end",
  ref_col = "ref", alt_col = "alt", sample_col = "sample"
)
}
