% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k_val_assit.R
\name{compare_k_vals}
\alias{compare_k_vals}
\title{Compare k values}
\usage{
compare_k_vals(
  musica,
  modality,
  reps = 100,
  min_k = 1,
  max_k = 10,
  error_type = "prop",
  algorithm = "nmf"
)
}
\arguments{
\item{musica}{A \code{\linkS4class{musica}} object.}

\item{modality}{The modality to use, either "SBS96", "DBS78", or "IND83".}

\item{reps}{Number of times prediction is performed. For each replicate, the
count table data is perturbed. Multiple replicates allows for stability
analysis by calculating silhouette width on the multiple results. Default
\code{100}.}

\item{min_k}{Lower range of number of signatures for discovery. Default
\code{1}.}

\item{max_k}{Upper range of number of signatures for discovery. Default
\code{10}.}

\item{error_type}{Whether to calculate reconstruction error by proportions
("prop") or raw counts ("raw"). Default \code{"prop"}.}

\item{algorithm}{Algorithm for signature discovery. Default \code{"nmf"}.}
}
\value{
a data.frame with stats for each k value tested
}
\description{
Compare the stability and error of various k values to help
determine the correct number of signatures (k).
}
\examples{
data(musica)
compare_k_vals(musica, "SBS96", reps = 3, min_k = 1, max_k = 5)
}
