% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans.R
\name{cluster_exposure}
\alias{cluster_exposure}
\title{Perform clustering analysis from a musica result object}
\usage{
cluster_exposure(
  musica,
  model_name,
  modality = "SBS96",
  result_name = "result",
  nclust,
  proportional = TRUE,
  method = "kmeans",
  dis.method = "euclidean",
  hc.method = "ward.D",
  clara.samples = 5,
  iter.max = 10,
  tol = 1e-15
)
}
\arguments{
\item{musica}{A \code{\linkS4class{musica}} object containing a mutational
discovery or prediction.}

\item{model_name}{The name of the desired model.}

\item{modality}{The modality of the model. Must be "SBS96", "DBS78", or
"IND83". Default \code{"SBS96"}.}

\item{result_name}{Name of the result list entry containing desired model.
Default \code{"result"}.}

\item{nclust}{Pre-defined number of clusters.}

\item{proportional}{Logical, indicating if proportional exposure (default)
will be used for clustering.}

\item{method}{Clustering algorithms. Options are "kmeans" (K-means),
"hkmeans" (hybrid of hierarchical
K-means), "hclust" (hierarchical clustering), "pam" (PAM), and "clara"
(Clara).}

\item{dis.method}{Methods to calculate dissimilarity matrix. Options are
"euclidean" (default), "manhattan", "jaccard", "cosine", and "canberra".}

\item{hc.method}{Methods to perform hierarchical clustering. Options are
"ward.D" (default), "ward.D2", "single", "complete", "average", "mcquitty",
"median", and "centroid".}

\item{clara.samples}{Number of samples to be drawn from dataset. Only used
when "clara" is selected. Default is 5.}

\item{iter.max}{Maximum number of iterations for k-means clustering.}

\item{tol}{Tolerance level for kmeans clustering level iterations}
}
\value{
A one-column data frame with sample IDs as row names and cluster
number for each sample.
}
\description{
Proportional sample exposures will be used as input to perform
clustering.
}
\examples{
set.seed(123)
data(res_annot)
clust_out <- cluster_exposure(res_annot, model_name = "res_annot",
nclust = 2)
}
\seealso{
\link[stats]{kmeans}
}
