% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_find_spacers.R
\name{extract_subranges}
\alias{extract_subranges}
\title{Extract subranges}
\usage{
extract_subranges(gr, ir, plot = FALSE)
}
\arguments{
\item{gr}{\code{\link[GenomicRanges]{GRanges-class}}}

\item{ir}{\code{\link[IRanges]{IRanges-class}}: subranges to be extracted}

\item{plot}{TRUE or FALSE (default)}
}
\value{
\code{\link[GenomicRanges]{GRanges-class}}.
}
\description{
Extract subranges from a \code{\link[GenomicRanges]{GRanges-class}} object
}
\examples{
# Extract a subrange
gr <- GenomicRanges::GRanges(c(A = 'chr1:1-100:+', B = 'chr1:1-100:-'))
gr$targetname <- 'AB'
ir <- IRanges::IRanges(c(A = '1-10', A = '11-20', B = '1-10', B = '11-20'))
extract_subranges(gr, ir, plot = TRUE)

# Return empty GRanges for empty IRanges 
extract_subranges(GenomicRanges::GRanges('chr1:345-456'), IRanges::IRanges())
}
