% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_processing.R
\name{rankFeatures}
\alias{rankFeatures}
\title{Pre-rank features prior to calculating enrichment scores.}
\usage{
rankFeatures(logFC, pvalues, base = 10)
}
\arguments{
\item{logFC}{Vector containing the log-transformed fold changes of features.}

\item{pvalues}{Vector containing the p-values associated with those logFCs.}

\item{base}{Integer specifying the base of the logarithm. Default: 10}
}
\value{
Vector of pre-ranked features, still unsorted
}
\description{
Rank features based on the direction of their fold change and their magnitude
implicated through their assigned p-value.
}
\examples{
logFC <- rnorm(10)
pvalues <- runif(10)
rankFeatures(logFC, pvalues)

}
