% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_processing.R
\name{initOmicsDataStructure}
\alias{initOmicsDataStructure}
\title{Create an empty data structure for measured omics features}
\usage{
initOmicsDataStructure(layer = c("transcriptome", "proteome", "metabolome"))
}
\arguments{
\item{layer}{List specifying the omics layer which should be created}
}
\value{
List with length(layer) empty sublists
}
\description{
This function creates a data structure of nested but empty lists. One list
for each omics layer. By default all three supported omics layer are used to
create a data structures with three empty sublists: transcriptome, proteome,
and metabolome.
}
\examples{
initOmicsDataStructure()
initOmicsDataStructure(c("transcriptome", "proteome"))
initOmicsDataStructure(c("Transcriptome", "Metabolome"))
}
