% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_fragpipe.R
\name{prepare_fragpipe}
\alias{prepare_fragpipe}
\title{prepare_fragpipe}
\usage{
prepare_fragpipe(
  combined_peptide_filepath,
  colData_filepath,
  peptide_library = mspms::peptide_library,
  n_residues = 4
)
}
\arguments{
\item{combined_peptide_filepath}{file path the combined_peptide.tsv file
generated by FragPipe.}

\item{colData_filepath}{file path to .csv file containing colData.
Must have columns named "quantCols","group","condition",and "time".}

\item{peptide_library}{peptide library used with experiment. Contains
columns "library_id", "library_match_sequence", and "library_real_sequence".}

\item{n_residues}{the number of amino acid residues before and after the
cleavage site to generate a cleavage seq for.}
}
\value{
a QFeatures object containing a summarizedExperiment named "peptides"
}
\description{
Prepare a label free quantification file exported from Fragpipe
for subsequent mspms analysis.
}
\examples{
fragpipe_combined_peptide <- system.file("extdata/fragpipe_combined_peptide.tsv", package = "mspms")
colData_filepath <- system.file("extdata/colData.csv", package = "mspms")
# Prepare the data
fragpipe_prepared_data <- mspms::prepare_fragpipe(fragpipe_combined_peptide, colData_filepath)
}
