% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purityD-subtract.R
\name{subtract,purityD-method}
\alias{subtract,purityD-method}
\alias{subtract}
\title{Using Subtract MZ values based on ppm tolerance and noise ratio}
\usage{
\S4method{subtract}{purityD}(
  Object,
  byClass = TRUE,
  mapping = c("sample", "blank"),
  ppm = 5,
  s2bthres = 10
)
}
\arguments{
\item{Object}{object; purityD object}

\item{byClass}{boolean; subtract within each class}

\item{mapping}{parameter not functional (TODO)}

\item{ppm}{numeric = ppm tolerance}

\item{s2bthres}{numeric = threshold for the samp2blank (i1/i2)}
}
\value{
purityD object with averaged spectra
}
\description{
Uses a purityD object with references to multiple MS files. Subtract blank peaks from the sample peaks
see subtractMZ for more information
}
\examples{
datapth <- system.file("extdata", "dims", "mzML", package="msPurityData")
inDF <- Getfiles(datapth, pattern=".mzML", check = FALSE, cStrt = FALSE)

ppDIMS <- purityD(inDF, cores=1)
ppDIMS <- averageSpectra(ppDIMS)
ppDIMS <- filterp(ppDIMS, thr = 5000)
ppDIMS <- subtract(ppDIMS)
}
\seealso{
\code{\link{subtractMZ}}
}
