% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_wrapper.R
\name{scoreDist}
\alias{scoreDist}
\title{Score distribution}
\usage{
scoreDist(pfm, bg)
}
\arguments{
\item{pfm}{An R matrix that represents a position frequency matrix}

\item{bg}{A Background object}
}
\value{
List that contains
\describe{
\item{scores}{Vector of scores}
\item{dist}{Score distribution}
}
}
\description{
This function computes the score distribution for the given PFM and
background. The Score distribution is computed based on an efficient
dynamic programming algorithm.
}
\examples{


# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seqs, 1)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Compute the score distribution
dp = scoreDist(motif, bg)

}
