#' motifTestR: Perform Key Analyses on Transcription Factor Binding Motifs
#'
#' The package `motifTestR` has been designed for two primary analyses of TFBMs,
#' testing for positional bias and overall enrichment.
#'
#' The package `motifTestR` provides two primary functions for testing TFBMs
#' within a set of sequences
#'
#' * [testMotifPos()] for detecting positional bias within a set of test
#' sequences
#' * [testMotifEnrich()] for testing overall enrichment of a TFBM within a set
#' of test sequences
#'
#' Motifs are also able to be clustered for analysis as a cluster, or for
#' grouping results.
#' Clusters from external approaches can also be incorporated.
#'
#' * [testClusterPos()] for detecting positional bias for matches to any motif
#' annotated to a cluster, within a set of test sequences
#' * [testClusterEnrich()] for testing overall enrichment of any TFBM annotated
#' to a cluster, within a set of test sequences
#'
#' The main functions rely on lower-level functions such as:
#'
#' * [countPwmMatches()] simply counts the number of matches within an
#' `XStringSet`
#' * [getPwmMatches()] returns the position of matches within an `XStringSet`
#' * [countClusterMatches()] simply counts the number of matches to motifs
#' annotated to a cluster within an `XStringSet`
#' * [getClusterMatches()] returns the position of matches to motifs annotated
#' to a cluster within an `XStringSet`
#' * [makeRMRanges()] which produces a set of random, matching ranges based on
#' key characteristics of the set of test sequences/ranges
#'
#' A simple utility function is provided to enable visualisation of results
#'
#' * [plotMatchPos()] enables visualisation of the matches within a set of
#' sequences using multiple strategies
#'
#' @author
#' Stevie Pederson
#'
#' @keywords internal
"_PACKAGE"
