% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosdef_check_inputs.R
\name{mosdef_res_check}
\alias{mosdef_res_check}
\title{A function checking if your res_de contains everything you need}
\usage{
mosdef_res_check(res_de, verbose = FALSE)
}
\arguments{
\item{res_de}{An object containing the results of the Differential Expression
analysis workflow (e.g. \code{DESeq2}, \code{edgeR} or \code{limma}).
Currently, this can be a \code{DESeqResults} object created using the \code{DESeq2}
framework.}

\item{verbose}{Logical, whether to add messages telling the user which steps
were taken}
}
\value{
An invisible \code{NULL} after performing the checks
}
\description{
A function checking if your res_de contains everything you need
}
\examples{
data(res_de_macrophage, package = "mosdef")

mosdef_res_check(res_macrophage_IFNg_vs_naive)
}
