% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/de2df.R
\name{deresult_to_df}
\alias{deresult_to_df}
\title{Generate a table from the \code{DESeq2} results}
\usage{
deresult_to_df(res_de, FDR = NULL)
}
\arguments{
\item{res_de}{An object containing the results of the Differential Expression
analysis workflow (e.g. \code{DESeq2}, \code{edgeR} or \code{limma}).
Currently, this can be a \code{DESeqResults} object created using the \code{DESeq2}
framework.}

\item{FDR}{Numeric value, specifying the significance level for thresholding
adjusted p-values. Defaults to NULL, which would return the full set of
results without performing any subsetting based on FDR.}
}
\value{
A tidy \code{data.frame} with the results from differential expression,
sorted by adjusted p-value. If FDR is specified, the table contains only
genes with adjusted p-value smaller than the value.
}
\description{
Generate a tidy table with the results of \code{DESeq2}
}
\examples{
library("DESeq2")
library("macrophage")
data(res_de_macrophage, package = "mosdef")
head(res_macrophage_IFNg_vs_naive)
res_df <- deresult_to_df(res_macrophage_IFNg_vs_naive)
head(res_df)
}
