% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_algorithms.R
\name{run_fabia}
\alias{run_fabia}
\title{Run the fabia biclustering algorithm}
\usage{
run_fabia(
  data_matrix,
  minRow = 2,
  minCol = 2,
  thresZ = 0.5,
  thresL = NULL,
  ...
)
}
\arguments{
\item{data_matrix}{A numeric matrix.}

\item{minRow}{Same parameters as in \link{filter_bicluster_size}.}

\item{minCol}{Same parameters as in \link{filter_bicluster_size}.}

\item{thresZ}{See parameter from the \link[fabia]{extractBic} function.}

\item{thresL}{See parameter from the \link[fabia]{extractBic} function.}

\item{...}{Other parameters forwarded to the \link[fabia]{fabia} function.}
}
\value{
a list of \link{bicluster} objects.
}
\description{
The function executes the \link[fabia]{fabia} biclustering algorithm,
returning a list of biclusters converted into bicluster objects
compatible with this package.
If the algorithm fails to run, an empty list is returned.
}
\examples{
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(1000), nrow=10)
# run_fabia(m, p=5)

}
