% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{full_graph}
\alias{full_graph}
\title{Generate a similarity network for a list of biclusters}
\usage{
full_graph(
  bics,
  m,
  rr_weight = 1L,
  rc_weight = 1L,
  cc_weight = 1L,
  weighting = 0L
)
}
\arguments{
\item{bics}{A list of biclusters.}

\item{m}{The matrix, that was used to calculated the biclusters.}

\item{rr_weight}{Weight row-row interactions.}

\item{rc_weight}{Weight row-col interactions.}

\item{cc_weight}{Weight col-col interactions.}

\item{weighting}{Weight interactions by bicluster size. 0 - no weighting, 
1 - multiply by bicluster size, 2 - divide by bicluster size.}
}
\value{
An adjacency matrix.
}
\description{
The function computes a adjacency 
matrix for rows and columns of biclusters.
The matrix values show, how often two rows or two columns or a row and a 
column occur together in biclusters.
In the resulting adjacency matrix, rows are listed first, followed 
by columns. 
They have the same order as the the rows and columns of the input matrix.
}
\details{
In case the given biclusters have overall more or less columns than rows, 
the interactions can be weighted to visualize the result properly.
}
\examples{
m <- matrix(seq(1:16), nrow=4)
b <- list(bicluster(row=c(1,2,3,4), column=c(1,2,3,4)),
        bicluster(row=c(3,4,5,6), column=c(3,4,5,6)),
        bicluster(row=c(3,4,5,6), column=c(3,4,5,6)))
# full_graph(b, m)

}
