% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_enrichment.R
\name{.normForKmers}
\alias{.normForKmers}
\title{Adjust for k-mer composition (single iteration)}
\usage{
.normForKmers(
  kmerFreq,
  goodKmers,
  kmerRC,
  seqWgt,
  isForeground,
  minSeqWgt = 0.001,
  maxSeqWgt = 1000
)
}
\arguments{
\item{kmerFreq}{A \code{list} with of matrices. The matrix at index \code{i}
in the list contains the probability of k-mers of length \code{i}, for each
k-mer (columns) and sequence (rows).}

\item{goodKmers}{A \code{list} of \code{numeric} vectors; the element at
index \code{i} contains the number of good (non-N-containing) k-mers of
length \code{i} for each sequence.}

\item{kmerRC}{A \code{list} of character vectors; the element at index
\code{i} contains the reverse complement sequences of all k-mers of length
\code{i}.}

\item{seqWgt}{A \code{numeric} vector with starting sequence weights
at the beginning of the iteration.}

\item{isForeground}{Logical vector of the same length as \code{seqs}.
\code{TRUE} indicates that the sequence is from the foreground,
\code{FALSE} that it is a background sequence.}

\item{minSeqWgt}{Numeric scalar greater than zero giving the
minimal weight of a sequence. The default value (0.001) is based on
\code{Homer} (HOMER_MINIMUM_SEQ_WEIGHT constant in Motif2.h).}

\item{maxSeqWgt}{Numeric scalar greater than zero giving the
maximal weight of a sequence. The default value (1000) is based on
\code{HOMER} (1 / HOMER_MINIMUM_SEQ_WEIGHT constant in Motif2.h).}
}
\value{
A named \code{list} with elements \code{seqWgt} (updated
  weights) and \code{err} (error measuring difference of foreground
  and weighted background sequence compositions).
}
\description{
Adjust background sequence weights for differences in k-mer
  composition compared to the foreground sequences. This function
  implements a single iteration, and is called iteratively by
  \code{.iterativeNormForKmers} to get to the final set of adjusted
  weights, which will be the result of adjusting for GC and k-mer
  composition. The logic is based on Homer's
  \code{normalizeSequenceIteration()} function found in \code{Motif2.cpp}.
}
\keyword{internal}
