% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAsummary.R
\name{RNAsummary}
\alias{RNAsummary}
\title{Summarise differential analysis results}
\usage{
RNAsummary(
  data,
  alpha = 0.1,
  chimeric = FALSE,
  controls = NULL,
  genome.ID = NULL
)
}
\arguments{
\item{data}{data.frame; generated by \code{\link[=RNAdifferentialAnalysis]{RNAdifferentialAnalysis()}}}

\item{alpha}{numeric; user-defined numeric value to represent the adjusted
p-value threshold to define statistical significance. Defaults setting
\code{alpha=0.1}.}

\item{chimeric}{logical; state whether system is chimeric: contains multiple
genomes/genotypes.}

\item{controls}{character; vector of control condition sample names.}

\item{genome.ID}{character; chromosome identifier of the genome representing
either the origin of mobile molecules or the other genome in the chimeric
system.}
}
\value{
Prints a summary of the RNAs which align with the
adjusted p-value cutoff and states the number which has a positive and
negative log-fold change. Where a positive log-fold change represents an
increase in abundance and a negative value represents a decrease in abundance
between the conditions.
}
\description{
Print a summary of the statistical analysis of sRNA clusters
(sRNAseq) or mRNAs (mRNAseq) from a mobileRNA analysis
}
\details{
To look only at the differential abundance from RNAs in the mobilome, use the
\code{chimeric=TRUE} parameter and supply the chromosome identifier of the genome
from which mobile molecules originate from to the \code{genome.ID} parameter &
the control condition samples names to the \code{controls} parameter.
}
\examples{

# load data 
data("sRNA_data")


# sample conditions.
groups <- c("Selfgraft", "Selfgraft", "Selfgraft", "Heterograft", "Heterograft", "Heterograft")


## Differential analysis: DEseq2 method
sRNA_DESeq2 <- RNAdifferentialAnalysis(data = sRNA_data,
                             group = groups,
                             method = "DESeq2" )
                          
                   
res <- RNAsummary(sRNA_DESeq2)
                                 
}
