% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAsubset.R
\name{RNAsubset}
\alias{RNAsubset}
\title{Subset sRNA data based on dicercall size}
\usage{
RNAsubset(data, class, statistical = FALSE, alpha = 0.05)
}
\arguments{
\item{data}{data.frame; generated by \code{\link[=RNAimport]{RNAimport()}}, containing
the additional information generated by \code{\link[=RNAdicercall]{RNAdicercall()}} which
defines the consensus sRNA class for each sRNA dicer-derived clusters}

\item{class}{numeric; sRNA dicercall class(es) to select. Based on size in
nucleotides.}

\item{statistical}{logical; filter and select statistically significant sRNA.
If \code{statistical=TRUE}, sRNA clusters are selected based on
p-adjusted alpha threshold.}

\item{alpha}{numeric; user-defined numeric value to represent the adjusted
p-value threshold to define statistical significance. Defaults setting
\code{alpha=0.05}.}
}
\value{
A data frame containing only sRNA clusters defined with a specific
sRNA dicer-derived consensus size.
}
\description{
Subset the existing dataframe to contain only the desired sRNA
class(s) based on the consensus dicercall determination and statistical
significance.
}
\details{
See \code{\link[=RNAdicercall]{RNAdicercall()}} for information on defining the consensus
sRNA dicercall class for each cluster. The function allows the choice to
filtered the data by statistical significance based on differential expression
analysis, see \code{\link[=RNAdifferentialAnalysis]{RNAdifferentialAnalysis()}}. Set
\code{statistical=TRUE} to filtered by statistical significance (p-adjusted).

It is important to consider what point in your analysis the data is subset
as it will drastically reduce your sample size, altering the output of
statistical analyse.
}
\examples{
# load data 
 data("sRNA_data")

# define consensus sRNA classes.
conditions <- c("heterograft_1", "heterograft_2", "heterograft_3")

# Run function to define sRNA class for each cluster.
sRNA_data_dicercall <- RNAdicercall(data = sRNA_data,
                                  conditions = conditions,
                                  tidy=TRUE)

# Subset data for  24-nt sRNAs
sRNA_24 <- RNAsubset(sRNA_data_dicercall, class = 24)


# Subset data for 21/22-nt sRNAs
sRNA_2122 <- RNAsubset(sRNA_data_dicercall, class = c(21, 22))

}
