% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{plot.bootmnem}
\alias{plot.bootmnem}
\title{Plot bootstrap mnem result.}
\usage{
\method{plot}{bootmnem}(x, reduce = TRUE, ...)
}
\arguments{
\item{x}{bootmnem object}

\item{reduce}{if TRUE transitively reduces the graphs}

\item{...}{additional parameters for the plotting function plotDNF}
}
\value{
visualization of bootstrap mnem result with Rgraphviz
}
\description{
Plot bootstrap mnem result.
}
\examples{
sim <- simData(Sgenes = 3, Egenes = 2, Nems = 2, mw = c(0.4,0.6))
data <- (sim$data - 0.5)/0.5
data <- data + rnorm(length(data), 0, 1)
result <- mnem(data, k = 2, starts = 1)
boot <- bootstrap(result, size = 2)
plot(boot)
}
\author{
Martin Pirkl
}
