% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{hamSim}
\alias{hamSim}
\title{Accuracy for two phis.}
\usage{
hamSim(a, b, diag = 1, symmetric = TRUE)
}
\arguments{
\item{a}{adjacency matrix (phi)}

\item{b}{adjacency matrix (phi)}

\item{diag}{if 1 includes diagonal in distance, if 0 not}

\item{symmetric}{comparing a to b is asymmetrical, if TRUE includes
comparison b to a}
}
\value{
normalized hamming accuracy for a and b
}
\description{
This function uses the hamming distance to calculate
an accuracy for two networks (phi).
}
\examples{
sim <- simData(Sgenes = 3, Egenes = 2, Nems = 2, mw = c(0.4,0.6))
similarity <- hamSim(sim$Nem[[1]], sim$Nem[[2]])
}
\author{
Martin Pirkl
}
