% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circosPlot.R
\name{circosPlot}
\alias{circosPlot}
\alias{circosPlot.block.splsda}
\alias{circosPlot.block.plsda}
\alias{circosPlot.block.spls}
\alias{circosPlot.block.pls}
\title{circosPlot for DIABLO}
\usage{
\method{circosPlot}{block.splsda}(
  object,
  comp = 1:min(object$ncomp),
  cutoff,
  color.Y,
  blocks = NULL,
  color.blocks,
  color.cor,
  var.names = NULL,
  showIntraLinks = FALSE,
  line = FALSE,
  size.legend = 0.8,
  ncol.legend = 1,
  size.variables = 0.25,
  size.labels = 1,
  legend = TRUE,
  legend.title = "Expression",
  linkWidth = 1,
  ...
)

\method{circosPlot}{block.plsda}(
  object,
  comp = 1:min(object$ncomp),
  cutoff,
  color.Y,
  blocks = NULL,
  color.blocks,
  color.cor,
  var.names = NULL,
  showIntraLinks = FALSE,
  line = FALSE,
  size.legend = 0.8,
  ncol.legend = 1,
  size.variables = 0.25,
  size.labels = 1,
  legend = TRUE,
  legend.title = "Expression",
  linkWidth = 1,
  ...
)

\method{circosPlot}{block.spls}(object, ..., group = NULL, Y.name = "Y")

\method{circosPlot}{block.pls}(object, ..., group = NULL, Y.name = "Y")
}
\arguments{
\item{object}{An object of class inheriting from \code{"block.plsda"},
\code{"block.splsda"}, \code{"block.pls"} or \code{"blocks.spls"}.}

\item{comp}{Numeric vector indicating which component to plot. Default to
all}

\item{cutoff}{Only shows links with a correlation higher than \code{cutoff}}

\item{color.Y}{a character vector of colors to be used for the levels of the
outcome}

\item{blocks}{Character or integer vector indicating which blocks to show.
Default to all}

\item{color.blocks}{a character vector of colors to be used for the blocks}

\item{color.cor}{a character vector of two colors. First one is for the
negative correlation, second one is for the positive correlation}

\item{var.names}{Optional parameter. A list of length the number of blocks
in \code{object$X}, containing the names of the variables of each block. If
\code{NULL}, the colnames of the data matrix are used.}

\item{showIntraLinks}{if TRUE, shows the correlation higher than the
threshold inside each block.}

\item{line}{if TRUE, shows the overall expression of the selected variables.
see examples.}

\item{size.legend}{size of the legend}

\item{ncol.legend}{number of columns for the legend}

\item{size.variables}{size of the variable labels}

\item{size.labels}{size of the block labels}

\item{legend}{Logical. Whether the legend should be added. Default is TRUE.}

\item{legend.title}{String. Name of the legend. Defaults to "Expression".}

\item{linkWidth}{Numeric. Specifies the range of sizes used for lines linking
the correlated variables (see details). Must be of length 2 or 1. Default to c(1). See details.}

\item{...}{For object of class \code{block.splsda}, advanced plot parameters:
\itemize{
 \item \bold{var.adj} Numeric. Adjusts the radial location of variable names in 
 units of the arc band width. Positive values push feature names radially 
 outward. Default to -0.33. See examples.
 \item \bold{block.labels.adj} Numeric between -1 and 1. Adjusts the radial
 location of block names radially inward or outward. Default to 0. See examples.
 \item \bold{blocks.link} Character vector of blocks. If provided, only correlations
 from features of these blocks are shown using links. See examples.
}
For object of class \code{block.spls}, all listed and advanced arguments
passed to the \code{block.splsda} method.}

\item{group}{The grouping factor used when \code{line = TRUE}}

\item{Y.name}{Character, the name of the \code{Y} block}
}
\value{
If saved in an object, the circos plot will output the similarity
matrix and the names of the variables displayed on the plot (see
\code{attributes(object)}).
}
\description{
Displays variable correlation among different blocks
}
\details{
\code{circosPlot} function depicts correlations of variables selected with
\code{block.splsda} or \code{block.spls} among different blocks, using a
generalisation of the method presented in González et al 2012. If
\code{ncomp} is specified, then only the variables selected on that component
are displayed.

The \code{linkWidth} argument specifies the width of the links drawn.
If a vector of length 2 is provided, the smaller value will correspond to
a similarity values designated by \code{cutoff} argument, while the 
larger value will be used for a link with perfect similarity (1), if any.
}
\examples{
data(nutrimouse)
Y = nutrimouse$diet
data = list(gene = nutrimouse$gene, lipid = nutrimouse$lipid)
design = matrix(c(0,1,1,1,0,1,1,1,0), ncol = 3, nrow = 3, byrow = TRUE)


nutrimouse.sgccda <- wrapper.sgccda(X=data,
Y = Y,
design = design,
keepX = list(gene=c(10,10), lipid=c(15,15)),
ncomp = 2)

circosPlot(nutrimouse.sgccda, cutoff = 0.7)
## links widths based on strength of their similarity
circosPlot(nutrimouse.sgccda, cutoff = 0.7, linkWidth = c(1, 10))
## custom legend
circosPlot(nutrimouse.sgccda, cutoff = 0.7, size.legend = 1.1)

## more customisation
circosPlot(nutrimouse.sgccda, cutoff = 0.7, size.legend = 1.1, color.Y = 1:5, 
           color.blocks = c("green","brown"), color.cor = c("magenta", "purple"))
    
par(mfrow=c(2,2))

circosPlot(nutrimouse.sgccda, cutoff = 0.7, size.legend = 1.1)
## also show intra-block correlations
circosPlot(nutrimouse.sgccda, cutoff = 0.7,
           size.legend = 1.1, showIntraLinks = TRUE)
## show lines
circosPlot(nutrimouse.sgccda, cutoff = 0.7, line = TRUE, ncol.legend = 1,
           size.legend = 1.1, showIntraLinks = TRUE)
## custom line legends
circosPlot(nutrimouse.sgccda, cutoff = 0.7, line = TRUE, ncol.legend = 2,
           size.legend = 1.1, showIntraLinks = TRUE)
par(mfrow=c(1,1))

## adjust feature and block names radially
circosPlot(nutrimouse.sgccda, cutoff = 0.7, size.legend = 1.1)
circosPlot(nutrimouse.sgccda, cutoff = 0.7, size.legend = 1.1, 
           var.adj = 0.8, block.labels.adj = -0.5)
## ---  example using breast.TCGA data
data("breast.TCGA")
data = list(mrna = breast.TCGA$data.train$mrna, 
            mirna = breast.TCGA$data.train$mirna, 
            protein = breast.TCGA$data.train$protein)
list.keepX = list(mrna = rep(20, 2), mirna = rep(10,2), protein = c(10, 2))

TCGA.block.splsda = block.splsda(X = data, 
                             Y =breast.TCGA$data.train$subtype,
                             ncomp = 2, keepX = list.keepX, 
                             design = 'full')
circosPlot(TCGA.block.splsda, cutoff = 0.7, line=TRUE)
## show only first 2 blocks
circosPlot(TCGA.block.splsda, cutoff = 0.7, line=TRUE, blocks = c(1,2))
## show only correlations including the mrna block features
circosPlot(TCGA.block.splsda, cutoff = 0.7, blocks.link = 'mrna')

data("breast.TCGA")
data = list(mrna = breast.TCGA$data.train$mrna, mirna = breast.TCGA$data.train$mirna)
list.keepX = list(mrna = rep(20, 2), mirna = rep(10,2))
list.keepY = c(rep(10, 2))

TCGA.block.spls = block.spls(X = data, 
                             Y = breast.TCGA$data.train$protein,
                             ncomp = 2, keepX = list.keepX, 
                             keepY = list.keepY, design = 'full')
circosPlot(TCGA.block.spls, group = breast.TCGA$data.train$subtype, cutoff = 0.7, 
           Y.name = 'protein')
## only show links including mrna
circosPlot(TCGA.block.spls, group = breast.TCGA$data.train$subtype, cutoff = 0.7, 
           Y.name = 'protein', blocks.link = 'mrna')

}
\references{
Singh A., Gautier B., Shannon C., Vacher M., Rohart F., Tebbutt
S. and Lê Cao K.A. (2016). DIABLO: multi omics integration for biomarker
discovery. BioRxiv available here:
\url{http://biorxiv.org/content/early/2016/08/03/067611}

mixOmics article:

Rohart F, Gautier B, Singh A, Lê Cao K-A. mixOmics: an R package for 'omics
feature selection and multiple data integration. PLoS Comput Biol 13(11):
e1005752

González I., Lê Cao K.A., Davis M.J., Déjean S. (2012). Visualising
associations between paired 'omics' data sets. \emph{BioData Mining};
\bold{5}(1).
}
\seealso{
\code{\link{block.splsda}}, references and
http://www.mixOmics.org/mixDIABLO for more details.
}
\author{
Michael Vacher, Amrit Singh, Florian Rohart, Kim-Anh Lê Cao, Al J Abadi
}
\keyword{multivariate}
\keyword{regression}
