% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vireo.R
\name{predictCellAssignment}
\alias{predictCellAssignment}
\title{Predict cell assignments from fitted Vireo model}
\usage{
predictCellAssignment(model, threshold = 0.9)
}
\arguments{
\item{model}{Fitted Vireo model}

\item{threshold}{Minimum probability threshold for assignment}
}
\value{
Data frame with cell assignments and probabilities
}
\description{
Predict cell assignments from fitted Vireo model
}
\examples{
load(system.file("extdata/LudwigFig7.Rda",package = "mitoClone2"))
test.data <- list(N=as.matrix(t(LudwigFig7@N)),M=as.matrix(t(LudwigFig7@M)))
vireoModel <- vireoFit(test.data, n.donor = 9, filter.variants = FALSE, min_cells_per_sample = 5)
cellAssignments <- predictCellAssignment(vireoModel, threshold = 0.9)
}
