% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj.R
\name{sparcc}
\alias{sparcc}
\title{Function for `sparcc` correlation calculation. Modified from
Schmidt et al. 2016, find the scripts
\href{https://github.com/defleury/Schmidt_et_al_2016_community_similarity}{here}
and the SparCC paper \href{https://doi.org/10.1371/journal.pcbi.1002687}{here}.}
\usage{
sparcc(x, threads = 80, nblocks = 400)
}
\arguments{
\item{x}{An matrix for correlation calculation.}

\item{threads}{The number of threads used for parallel running, 80 by
default.}

\item{nblocks}{The number of row /column for splitting sub-matrix, 400 by
default.}
}
\value{
y The adjacency matrix.
}
\description{
Function for `sparcc` correlation calculation. Modified from
Schmidt et al. 2016, find the scripts
\href{https://github.com/defleury/Schmidt_et_al_2016_community_similarity}{here}
and the SparCC paper \href{https://doi.org/10.1371/journal.pcbi.1002687}{here}.
}
\examples{
\dontrun{
asv_sparcc <- sparcc(maize_asv2, threads = 2, nblocks = 40)
}
}
\keyword{internal}
